<?php

$projID = "pj2";
$custID = "cheung";


/* =====================================================
   Read project due dates from "assigns.csv" CSV file
   ===================================================== */
$rows = array_map('str_getcsv', file('assigns.csv'));
$header = array_shift($rows);
$assignment = array();
foreach ($rows as $row) 
{
  $assignment[] = array_combine($header, $row);
}

/*
print_r($assignment);
print_r($assignment[0]);
print($assignment[0]["proj"]);
print($assignment[0]["due"]);
*/

$due = "";

/* -------------------------------------------------
   Look up due date for $projID
   ------------------------------------------------- */
for ($i = 0; $i < sizeof($assignment); $i++ )
{
   print($assignment[$i]["proj"] . " --- ");
   print($assignment[$i]["due"] . "\n");

   if ( $assignment[$i]["proj"] == $projID )
   {
      $due =  $assignment[$i]["due"] . " 01:00:00";
      break;
   }
}

if ( $due == "" )
{
   print( $projID . " NOT FOUND in assignment list - tell prof !\n");
   exit();
}

/* =============================================
   Check turn in deadline 
   ============================================= */
$timedue = strtotime($due);

$now = date('Y-m-d h:i:s');
$timenow = strtotime($now);

if ( $timenow <= $timedue )
{
    echo "Accept: <B>$now</B> is before due time <B>$due</B>";

    exit();
}


echo "<B>$now</B> is later than due date <B>$due</B>\n";
echo "Check extension requests\n";

/* =====================================================
   Read extension request CSV file
   ===================================================== */
$extfile = "req-ext/" . $projID ;
$rows = array_map('str_getcsv', file($extfile));
$header = array_shift($rows);
$ext = array();
foreach ($rows as $row)
{
  $ext[] = array_combine($header, $row);
}

// print_r($ext);

$due = "";

/* -------------------------------------------------
   Look up due date for $custID
   ------------------------------------------------- */
for ($i = 0; $i < sizeof($ext); $i++ )
{
   print($ext[$i]["studID"] . " --- ");
   print($ext[$i]["due"] . "\n");

   if ( $ext[$i]["studID"] == $custID )
   {
      $due =  $ext[$i]["due"] . " 01:00:00";
      print("Extension good for: " . $due . "\n");
      break;
   }
}

if ( $due == "" )
{
   print( "NO extension request found for " . $custID . "\n");
   exit();
}

/* =============================================
   Check turn in deadline
   ============================================= */
$timedue = strtotime($due);

$now = date('Y-m-d h:i:s');
$timenow = strtotime($now);

if ( $timenow <= $timedue )
{
    echo "Accept: <B>$now</B> is before due time <B>$due</B>";

    exit();
}


?>
