<!-------------------------------------------------------------
   Requirements:

       1. create $assignFile

          Format:
		"proj","due"
		"pj1","2023-08-09"
		"pj2","2023-08-29"

       2. create req-ext directory

       3. create EMPTY extension data file  pj#

          Content:
		"studID","due"

       4. make extension data file writable to HTTP daemon

		chmod 666 req-ext/*
  ------------------------------------------------------------>
<?php

// File
$assignFile = "./assigns.csv";
$ODSFile = "./ODS";
$extDir = "req-ext";
$MAX = 3;

?>


<!DOCTYPE html>
<html>
<body>

<H3>
<HR>
CS 171 extension request
<HR>
</H3>

&nbsp;
<P>



<?php
$stu = $_POST["custId"];
$proj = $_POST["proj"];

// Test
//$stu="cheung";
//$proj="pj2";

// echo $stu;
// echo "<P>";
// echo $proj;
// echo "<P>";


/* =====================================================
   Read project due dates from $assignFile CSV file
   ===================================================== */
$rows = array_map('str_getcsv', file($assignFile));
$header = array_shift($rows);
$assignment = array();
foreach ($rows as $row)
{
  $assignment[] = array_combine($header, $row);
}

//print_r($assignment);
//print_r($assignment[0]);
//print($assignment[0]["proj"]);
//print($assignment[0]["due"]);

$due = "";

/* -------------------------------------------------
   Look up due date for $proj
   ------------------------------------------------- */
$origDate = "";
for ($i = 0; $i < sizeof($assignment); $i++ )
{
// print($assignment[$i]["proj"] . " --- ");
// print($assignment[$i]["due"] . "\n");

   if ( $assignment[$i]["proj"] == $proj )
   {
      $origDate = $assignment[$i]["due"];
      $due =  $assignment[$i]["due"] . " 23:59:59";
      break;
   }
}

if ( $due == "" )
{
   print("ERROR: " . $proj . " NOT FOUND in assignment list - tell prof !\n");
   exit();
}


/* =============================================
   Check turn in deadline
   ============================================= */
$timedue = strtotime($due);

$now = date('Y-m-d h:i:s');
$timenow = strtotime($now);

if ( $timenow > $timedue )
{
// Reject extension request
?>

<!---------------------- Reject because now > time due ------------>
<CENTER>
<TABLE bgcolor="lightyellow" BORDER="5" width=700>
<TR> <TD>
<FONT SIZE="+0">
 <UL>
 <LI> Extension request by
	<?php echo $stu ?> 
	for project 
	<?php echo $proj ?> 
   <P>
 <LI> Project <?php echo $proj ?> is due on: 
	<B><?php echo $due ?> </B>
  <P>
 <LI> Time is now: <B><?php echo $now ?></B>
  <P>
  Your extension request was 
      <font color="blue"><B>not successful</B> </font>
	 because the 
	<font color="red"><B>request was made after deadline</B> </font>
  <P>
 </UL>
</TD></TR>
</TABLE>
</CENTER>

<?php

   exit();
}
?>

<!---------------------- Check if student made ext req already ------------>
<?php
//  echo "Accept: <B>$now</B> is before due time <B>$due</B>";

    $extFileName = $extDir . "/" . $proj;

//  echo $extFileName;
//  echo "<P>";

    /* ==========================================
       Check if student made a request already
       ========================================== */
    $cmd = "grep " . $stu . " " . $extFileName;
    $out = exec($cmd);

    if ( $out != "" )
    {
?>

<!----------------- Reject because student made ext req for project ----->
<CENTER>
<TABLE bgcolor="lightyellow" BORDER="5" width=700>
<TR> <TD>
<FONT SIZE="+0">
 <UL>
 <LI> Extension request by
        <B><?php echo $stu ?></B>
        for project
        <B><?php echo $proj ?></B>
   <P>
  Our records show that you have already receive an extension for 
  this project:
  <UL>
      <font color="blue"><B><TT><?php echo $out ?> </TT></B> </font>
  </UL>
  <P>
  You cannot request more than 1 extension for the same project.
  <P>
 </UL>
</TD></TR>
</TABLE>
</CENTER>

<?php
       exit();		// Done
    }
?>


<!------------ ODS student -------->
<?php

/* =====================================================
   Read ODS student ID file
   ===================================================== */
$rows = array_map('str_getcsv', file($ODSFile));
$header = array_shift($rows);
$assignment = array();
foreach ($rows as $row)
{
  $assignment[] = array_combine($header, $row);
}

//print_r($assignment);
//print_r($assignment[0]);
//print($assignment[0]["studID"]);


$isODS= 0;

/* -------------------------------------------------
   Look up due date for $proj
   ------------------------------------------------- */
for ($i = 0; $i < sizeof($assignment); $i++ )
{
// print($assignment[$i]["studID"] . "\n");

   if ( $assignment[$i]["studID"] == $stu )
   {
      $isODS = 1;
      break;
   }
}
?>




<!------------ Check # ext req made -------->

<?php
    $allExtFiles = $extDir . '/*' ;

    /* ==========================================
       Check if student made a request already
       ========================================== */
    $cmd = "grep " . $stu . " " . $allExtFiles ;
//  print($cmd . "<P>");
    exec($cmd, $outputLines);

    $out = count( $outputLines );

    // If not ODS students and made MAX ext requests ---> deny
    if ( $isODS == 0 && $out >= $MAX )
    {
?>

<!------------ exceeds MAX ext req -------->
<CENTER>
<TABLE bgcolor="lightyellow" BORDER="5" width=700>
<TR> <TD>
<FONT SIZE="+0">
 <UL>
 <LI> Extension request by
        <B><?php echo $stu ?></B>
        for project
        <B><?php echo $proj ?></B>
   <P>
  Our records show that you have already received
 <B><?php echo count($outputLines); ?></B> extension:
  <UL>
      <font color="blue"><B><TT>
      <?php for ($i = 0; $i < count($outputLines); $i++) 
            {
               print($outputLines[$i] . "<BR>\n");
            } 
      ?> 
      </TT></B> </font>
  </UL>
  <P>
  You cannot request for extension anymore
  <P>
 </UL>
</TD></TR>
</TABLE>
</CENTER>


<?php
      exit();
    }
?>



<!------------ Append ext req -------->
<?php
    // ==========================================
    // Add 3 more days to original due date
    // ==========================================
    $newDate = date('Y-m-d', strtotime($origDate . ' + 3 days'));

    // echo $origDate;
    // echo "<P>";
    // echo $newDate;
    // echo "<P>";

    $line = '"' . $stu . '","' . $newDate . '"' . "\n";

    /* ==========================================
    // Append to req-ext/proj file
       ========================================== */
    // opening the file in append mode
    $fp = fopen($extFileName, 'a');

    // writing new lines to the file
    $err = fwrite($fp , $line);

    // Closing the file
    if( $err )
    {
?>

<!------------ exceeds MAX ext req -------->
<CENTER>
<TABLE bgcolor="lightyellow" BORDER="5" width=700>
<TR> <TD>
<FONT SIZE="+0">
 <UL>
 <LI> Extension request by
        <B><?php echo $stu ?></B>
        for project
        <B><?php echo $proj ?></B> was <B>successfully processed</B>
   <P>
   The new turn in date is:
  <UL>
      <font color="blue"><B><TT>
      <?php 
             echo $newDate . " (before midnight)";
      ?>
      </TT></B> </font>
  </UL>
  <P>
 </UL>
</TD></TR>
</TABLE>
</CENTER>

<?php
    }
    else
    {
?>


<CENTER>
<TABLE bgcolor="lightyellow" BORDER="5" width=700>
<TR> <TD>
<FONT SIZE="+0">
 <UL>
 <LI> There was a <font color="red"><B>error</B></font> while writing
       the extension file  
   <P>
  <UL>
      <font color="blue"><B>
	Report this to your professor !
      </B> </font>
  </UL>
  <P>
 </UL>
</TD></TR>
</TABLE>
</CENTER>


<?php
    }
    fclose($fp);

?>



