
<?php

function validateDate($date, $format = 'Y-n-j')
{
    $d = DateTime::createFromFormat($format, $date);
    // The Y ( 4 digits year ) returns TRUE for any integer 
    // with any number of digits so changing the comparison 
    // from == to === fixes the issue.
    return $d && $d->format($format) === $date;
}

var_dump(validateDate('2013-13-01'));  // false
var_dump(validateDate('20132-13-01')); // false
var_dump(validateDate('2013-11-32'));  // false
var_dump(validateDate('2012-2-25'));   // false
var_dump(validateDate('2013-12-01'));  // true
var_dump(validateDate('1970-12-01'));  // true
var_dump(validateDate('2012-02-29'));  // true
var_dump(validateDate('2012', 'Y'));   // true
var_dump(validateDate('12012', 'Y'));  // false

$x = "2020-01-01";
if ( validateDate($x) || validateDate($x, "Y-m-d") )
   print("OK\n");
else
   print("Error\n");
?>
