
public class DealCard
{
    
    public static void main(String[] args)
    {
        int[] deck = new int[52];
        
        for ( int i = 0; i < deck.length; i++ )
            deck[i] = i;  // 0, 1, 2, ...., 51
            
        // "Deal" 4 cards
        for ( int i = 0; i < 4; i++ )
            System.out.println( num2Card(deck[i]) );
            
        System.out.println();
       
        // Randomly shuffle the deck of cards
        for (int i = 0; i < deck.length; i++) 
        { // Generate an index randomly
            int j = (int)(Math.random() * deck.length);

            int temp = deck[i];   // Swap
            deck[i] = deck[j];
            deck[j] = temp;
        }
             
        // "Deal" 4 cards
        for ( int i = 0; i < 4; i++ )
            System.out.println( num2Card(deck[i]) );     
    } 
    
    public static String num2Card( int n )
    {
        /* --------------------------------------------------
           Help arrays to translate the card code (0 - 51)
           to their English names
       -------------------------------------------------- */
        String[] suits = {"Spades", "Hearts", "Diamonds", "Clubs"};

        String[] ranks = {"Ace", "2", "3", "4", "5", "6", "7", 
                         "8", "9", "10", "Jack", "Queen", "King"};
                       
        int cardSuit = n/13;
        int cardRank = n%13;
        
        return ranks[cardRank] + " of " + suits[cardSuit];
    }
}
